SELECT tsystem.function__drop_by_regex( 'resource_timeline__resource_block_time__insert', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__resource_block_time__insert(
      _resource_id integer,
      _timeframe_start timestamp,
      _timeframe_end timestamp
  ) RETURNS int AS $$
  DECLARE
      _block_id int;
  BEGIN

          -- delete containing blocktimes
        DELETE FROM scheduling.resource_timeline
        WHERE
           -- this is explicitly the contains operator to delete the inner blocked dates, not the edges,
           -- since we need to update those
           tsrange( _timeframe_start , _timeframe_end, '[]') &&
           tsrange(ti_date_start, ti_date_end, '[]')
           AND ti_date_start >= _timeframe_start
           AND ti_date_end <= _timeframe_end
           AND ti_resource_id = _resource_id
           AND ti_type IN ( 'off.day', 'off.time' );

        -- update lower edges
        UPDATE scheduling.resource_timeline SET ti_date_end = _timeframe_start
        WHERE
           ti_resource_id = _resource_id AND
           ti_type IN ( 'off.day', 'off.time' ) AND
           tsrange( _timeframe_start , _timeframe_end, '[]') &&
           tsrange(ti_date_start, ti_date_end, '[]')
           AND ti_date_start < _timeframe_start;

        -- update upper edge
        UPDATE scheduling.resource_timeline SET ti_date_start = _timeframe_end
        WHERE
           ti_resource_id = _resource_id AND
           ti_type IN ( 'off.day', 'off.time' ) AND
           tsrange( _timeframe_start , _timeframe_end, '[]') &&
           tsrange(ti_date_start, ti_date_end, '[]')
           AND ti_date_start < _timeframe_end
           AND ti_date_end >= _timeframe_end;

        -- insert middle portion
        INSERT INTO scheduling.resource_timeline ( ti_date_start, ti_date_end, ti_type, ti_resource_id )
        VALUES ( _timeframe_start, _timeframe_end, 'off', _resource_id )
        RETURNING ti_id INTO _block_id;

        RETURN _block_id;

  END $$ language plpgsql;

